#include "MPC551x.h"
#include "Adc.h"


#define ON  1
#define OFF 0
#define Z0_CORE OFF 
/* Prototype for PRC1 startup */
extern void __start_p1();
void vfnPit_Init_Z1(void);    
void vfnPit_Ch1_Isr(void);
void vfnInit_PLL(void);
void enableIrq_p0(void);
void vfnAdc_Init_Port_Pins(void);
void SendConvCmd (void);
void initADC0(void);

uint16_t u16Read_Result = 0;
              
void vfnInit_PLL(void)
{
      
    CRP.CLKSRC.B.XOSCEN = 1;          /* Enable external oscillator */
    FMPLL.ESYNCR2.R = 0x00000007;     /* Set ERFD to initial value of 7 */
    FMPLL.ESYNCR1.R = 0xF0010030;     /* Set CLKCFG=PLL, EPREDIV=1, EMFD=0x30 */
    while (FMPLL.SYNSR.B.LOCK != 1) {}; /* Wait for PLL to LOCK  */
    FMPLL.ESYNCR2.R = 0x00000003;     /* Set ERFD to final value for 64 MHz sysclk */
    SIU.SYSCLK.B.SYSCLKSEL = 2;       /* Select PLL for sysclk */
}

void vfnAdc_Init_Port_Pins(void)
{
   uint8_t u8PortNo = 0;
   	
  	for(u8PortNo = MAX_ADC_CHANNELS ; u8PortNo > 0 ; u8PortNo-- )
  	{
  	    SIU.PCR[au8Adc_Port_Pins[u8PortNo - 1]].R = (uint16_t)0x0500;
  	}
}

void enableIrq_p0(void) 
{                               /* Use one of the following two lines: */
  INTC.CPR_PRC0.B.PRI = 0;     /* MPC551x Proc'r 0: Lower INTC's current priority */
  asm(" wrteei 1");	    	   /* Enable external interrupts */
}

 
void main(void) 
{
  volatile int i = 0;

  SIU.PCR[16].R = 0x0200;
  /* Initialize system bus at 64MHz   */
  vfnInit_PLL();
  vfnPit_Init_Z1();
  /* Now setup EMIOS200 */     
  INTC_InstallINTCInterruptHandler(vfnPit_Ch1_Isr,149,1);
  /* Initialize ADC pins  */
   vfnAdc_Init_Port_Pins();
   /* Initialize ADC0 module with predefined parameters from Adc_Cfg.h file */
   initADC0();
   //vfnAdc_Init(); 
   /* Initialize DMA engine to handle ADC conversions */
   vfnedma_init();
   /* Configures TCD channels 0 & 1                   */
   vfndma_config_fcn();
   /* Start ADC0 Calibration  */
   //vfnInitAdc_Calibration(ADC_FIFO_BUFFER);
   /* Start the other core by writing CRP.Z0VEC.R */ 
   CRP.Z0VEC.R = (unsigned long)__start_p1;
   enableIrq_p0();                

    for(;;)
    {
        //SIU.GPDO[16].R = 1;
       //initADC0();
       //SendConvCmd();
       /* Start Conversion using channel AN0- PA0 */
       // vfnStart_Conversion_fnc(ADC_CHANNEL_0,ADC_CAL_DISABLE);
       /* Read result from Receive Fifo 0  */
       // u16Read_Result = (uint16_t)u16Read_Adc_Result(ADC_FIFO_BUFFER);
       // u16Read_Result = (uint16_t)((uint16_t)u16Read_Result >> (uint16_t)2);
       // SIU.GPDO[16].R = 0;
    }
}


void initADC0(void) 
{
  uint32_t u32Test;
  
  /*0x80801001 */
  u32Test  = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD];
  
  EQADC.CFPR[0].R = (uint32_t)0x80801001;
//    0x80801001                          /* enable ADC0 & sets prescaler= divide by 2 */ 
  EQADC.IDCR[0].R = (uint16_t)0x0303;                                    
  EQADC.CFCR[0].R = 0x0410;           /* Trigger CFIFO 0 using Single Scan SW mode */
  EDMA.CERQR.R = 0x1;										// Disable eDMA to RQUEUE0
  while (EQADC.FISR[0].B.EOQF !=1) {} /* Wait for End Of Queue flag */
  EQADC.FISR[0].B.EOQF = 1;           /* Clear End Of Queue flag */
}

void SendConvCmd (void) 
{
  //EQADC.CFPR[0].R = 0x80000000; /* Conversion command: convert channel 0 */
                                /* with ADC0, set EOQ, and send result to RFIFO 0 */ 
  cQUEUE0 = 0x80000000;                                
  //EQADC.CFCR[0].R = 0x0410;     /* Trigger CFIFO 0 using Single Scan SW mode */
  /* Disable DMA trigerring                 */
   ADC_DMA_CR(ADC_FIFO_BUFFER,0x0000);  
  /* Invalidate  command queue 0            */ 
  ADC_INVALIDATE_CFIFO(ADC_FIFO_BUFFER);        
  /* Enable DMA triggering                  */
  ADC_DMA_CR(ADC_FIFO_BUFFER,0x0303);  
  /* Set ADC Mode as Single Scan Sw Trigger */
  EQADC.CFCR[0].B.MODE = SW_TRIG_SS;
  /* Set SSE bit on CFCRx register          */
  ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);
}

void vfnPit_Init_Z1(void)
{
     PIT.CTRL.R = (uint32_t)0x00;                                          /* MDIS = 0 - Enable Module */
     PIT.TLVAL1.R = 0x000018C0;
   #if Z0_CORE == ON 
     INTC.PSR[149].R = (uint8_t)0xC1; /* Raise Pit Channel Priority */    
   #else
     INTC.PSR[149].R = 1; /* Raise Pit Channel Priority */    
   #endif
     PIT.FLG.R      = (PIT.FLG.R    | 0x02); /* Clear Interrupt flag to avoid false triggers   */
     PIT.INTSEL.R   = (PIT.INTSEL.R | 0x02); /* Generate Hw interrupt instead of DMA Interrupt */
     PIT.INTEN.R    = (PIT.INTEN.R  | 0x02); /* Enable Pit Interrupts                          */
     PIT.EN.R       =  (PIT.EN.R | (1 << 1));
}

void vfnPit_Ch1_Isr(void)
{
    SIU.GPDO[16].R ^= 1;
    /* Trigger eDMA Channel 0 to transfer ADC Command */
    ADC_SET_SSE_BIT(ADC_FIFO_BUFFER);
    /* Read result from Receive Fifo 0  */
    u16Read_Result = (uint16_t)u16Read_Adc_Result(ADC_FIFO_BUFFER);
    u16Read_Result = (uint16_t)((uint16_t)u16Read_Result >> (uint16_t)2);
       
   /* Clear the real time interrupt flag */
   PIT.FLG.R = (PIT.FLG.R | 0x02);  /* Clear channel's flag */ 
 	
}